/////////////////////////////////////////////////////////////
//	File:		"COptionsState.h"
//
//	Author:		Jason Stegner (JS)
//
//	Purpose:	Allows the user to modify game settings
/////////////////////////////////////////////////////////////

#ifndef COPTIONSSTATE_H_
#define COPTIONSSTATE_H_

#include <windows.h>

#include "IGameState.h"

// Forward declarations
class CSGD_Direct3D;
class CSGD_TextureManager;
class CSGD_FModManager;

enum {EASY = 0, MEDIUM, HARD};

class COptionsState : public IGameState
{
private:
	// Pointer for the Direct3D wrapper
	CSGD_Direct3D*			m_pD3D;
	// Pointer for the texture manager
	CSGD_TextureManager*	m_pTM;
	// Pointer for FMOD
	CSGD_FModManager*		m_pFM;


	// Floats for music volume and sound effects volume in game
	float					m_fMusicVolume,  m_fMaxMusicVolume;
	// Booleans for other options.  
	bool					m_bDisplayFPS, m_bWindowed;

	int						m_nSelection;	//	The current selection of the menu
	int						m_nDummyImageID;

	//Word IDs
	int m_nSoundVolume;
	int m_nDifficultySelections;
	int m_nDifficulty;
	int m_nExit;
	int m_nOptions;

	
	int						m_nMusicID;		//	ID for the music and sound effect
	int						m_nBarImage;	//	ID for the Bar graphic
	int						m_nBarSize;		//	The size of the bar.
	RECT					m_rMusicBar;	//	The music bar's rect.

	int						m_nDifficultyID;	//	The difficulty of the game.


	//	Used for the percentage of the gauge's life, and length of the bar currently.
	float					fPercent1, fPercent2;
	int						nLength1, nLength2;

	bool					m_bIsGamePlay;	// Bool to tell if the options state was entered through the game play state.

	//////////////////////////////////////////
	// Function: "COptionsState"
	// Purpose:  Constructor
	//////////////////////////////////////////
	COptionsState();
	//////////////////////////////////////////
	// Function: "~COptionsState"
	// Purpose:  Destructor
	//////////////////////////////////////////
	~COptionsState();
	//////////////////////////////////////////
	// Function: "COptionsState"
	// Purpose:  Copy constructor
	//////////////////////////////////////////
	COptionsState(const COptionsState&);
	//////////////////////////////////////////
	// Function: "operator="
	// Purpose:  Overloaded assignment operator
	//////////////////////////////////////////
	COptionsState& operator=(const COptionsState&);
public:
	//////////////////////////////////////////
	// Function: "GetInstance"
	// Purpose:  Returns the instance of the 
	//			 COptionsState class
	//////////////////////////////////////////
	static COptionsState* GetInstance();

	//////////////////////////////////////////
	// Function: "Enter"
	// Purpose:  Initializes the class upon
	//			 starting to use it
	//////////////////////////////////////////
	void Enter(void);

	//////////////////////////////////////////
	// Function: "Exit"
	// Purpose:  Cleans up the class for while
	//			 it is not being used
	//////////////////////////////////////////
	void Exit(void);

	//////////////////////////////////////////
	// Function: "Input"
	// Purpose:  Handles input for the options
	//			 based on time
	//////////////////////////////////////////
	bool Input(float fElapsedTime);
	//////////////////////////////////////////
	// Function: "Update"
	// Purpose:  Updates the class based on time
	//////////////////////////////////////////
	void Update(float fElapsedTime);
	//////////////////////////////////////////
	// Function: "Render"
	// Purpose:  Draws the options menu
	//////////////////////////////////////////
	void Render(void);



	//////////////////////////
	//		ACCESSORS		//
	//////////////////////////
	float GetMusicVolume() {return m_fMusicVolume;}
	bool GetDisplayFPS() {return m_bDisplayFPS;}
	bool GetIsWindowed() {return m_bWindowed;}
	int	GetDifficulty(void) {return m_nDifficulty; }
	bool GetIsGamePlay()  { return m_bIsGamePlay; }

	//////////////////////////
	//		 MUTATORS		//
	//////////////////////////
	void SetMusicVolume(float fVolume) { m_fMusicVolume = fVolume; }
	void SetDisplayFPS(bool bFPS) { m_bDisplayFPS = bFPS; }
	void SetIsWindowed(bool bWindowed) { m_bWindowed = bWindowed; }
	void SetDifficulty(int nDifficulty) { m_nDifficulty = nDifficulty; }
	void SetIsGamePlay(bool bIsGamePlay)	{m_bIsGamePlay = bIsGamePlay;}
};

#endif
